package com.yc.rss.radio;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

/**
 * Created by yc on 8/13/15.
 * https://developer.android.com/training/basics/network-ops/xml.html
 */
/*
<channel>
	<title>France Info</title>
	<mp3>https://files.kawi.fr:8000/finfo64</mp3>
	<shortname>finfo</shortname>
	<icy>0</icy>
</channel>
 */
public class Entry {
    public final String title;
    public final String mp3;
    public final String shortname;
    public final String icy;
    public static final String ns = null;

    public Entry(String title, String mp3, String shortname, String icy) {
        this.title = title;
        this.mp3 = mp3;
        this.shortname = shortname;
        this.icy = icy;
    }

    // Parses the contents of an entry. If it encounters a title, summary, or link tag, hands them off
    // to their respective "read" methods for processing. Otherwise, skips the tag.
    public static Entry readItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(XmlPullParser.START_TAG, ns, "item");
        String title = null;
        String mp3 = null;
        String shortname = null;
        String icy = null;
        while (parser.next() != XmlPullParser.END_TAG) {
            if (parser.getEventType() != XmlPullParser.START_TAG) {
                continue;
            }
            String name = parser.getName();
            if (name.equals("title")) {
                title = readTitle(parser);
            } else if (name.equals("mp3")) {
                mp3 = readMp3(parser);
            } else if (name.equals("shortname")) {
                shortname = readShortname(parser);
            } else if (name.equals("icy")) {
                icy = readIcy(parser);
            } else {
                skip(parser);
            }
        }
        return new Entry(title, mp3, shortname, icy);
    }

    // Processes title tags in the feed.
    public static String readTitle(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "title");
        String title = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "title");
        return title;
    }

    // Processes category tags in the feed.
    public static String readMp3(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "mp3");
        String mp3 = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "mp3");
        return mp3;
    }

    // Processes link tags in the feed.
    public static String readShortname(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "shortname");
        String shortname = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "shortname");
        return shortname;
    }

    // Processes summary tags in the feed.
    public static String readIcy(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "icy");
        String icy = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "icy");
        return icy;
    }

    // For the tags title and summary, extracts their text values.
    public static String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == XmlPullParser.TEXT) {
            result = parser.getText();
            parser.nextTag();
        }
        return result;
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != XmlPullParser.START_TAG) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case XmlPullParser.END_TAG:
                    depth--;
                    break;
                case XmlPullParser.START_TAG:
                    depth++;
                    break;
            }
        }
    }
}
