package com.yc.rss.radio;

import android.util.Log;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

/**
 * Created by yc on 8/13/15.
 * https://developer.android.com/training/basics/network-ops/xml.html
 */
/*
<channel>
	<title>France Info</title>
	<mp3>https://files.kawi.fr:8000/finfo64</mp3>
	<shortname>finfo</shortname>
	<icy>0</icy>
</channel>
 */
public class EntryTag {
    public String title;
    public String shortname;
    public String track_title;
    public String track_artist;
    public String track_url;
    public String cover = null;
    public static final String ns = null;

    public EntryTag(String title, String shortname, String track_title, String track_artist, String track_url, String cover) {
        this.title = title;
        this.shortname = shortname;
        this.track_title = track_title;
        this.track_artist = track_artist;
        this.track_url = track_url;
        this.cover = cover;
    }

    public static EntryTag readItem(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(XmlPullParser.START_TAG, ns, "channel");
        String title = null;
        String shortname = null;
        String track_title = null;
        String track_artist = null;
        String track_url = null;
        String cover = null;
        while (parser.next() != XmlPullParser.END_TAG) {
            if (parser.getEventType() != XmlPullParser.START_TAG) {
                continue;
            }
            String name = parser.getName();
            if (name.equals("title")) {
                title = readTitle(parser);
            } else if (name.equals("shortname")) {
                shortname = readShortname(parser);
            } else if (name.equals("track_title")) {
                track_title = readTrackTitle(parser);
            } else if (name.equals("track_artist")) {
                track_artist = readTrackArtist(parser);
            } else if (name.equals("track_url")) {
                track_url = readTrackURL(parser);
            } else {
                skip(parser);
            }
        }
        return new EntryTag(title, shortname, track_title, track_artist, track_url, cover);
    }

    public static String readTitle(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "title");
        String title = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "title");
        return title;
    }

    public static String readShortname(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "shortname");
        String shortname = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "shortname");
        return shortname;
    }

    public static String readTrackTitle(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "track_title");
        String icy = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "track_title");
        return icy;
    }
    public static String readTrackArtist(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "track_artist");
        String icy = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "track_artist");
        return icy;
    }
    public static String readTrackURL(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(XmlPullParser.START_TAG, ns, "track_url");
        String icy = readText(parser);
        parser.require(XmlPullParser.END_TAG, ns, "track_url");
        return icy;
    }

    public static String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == XmlPullParser.TEXT) {
            result = parser.getText();
            parser.nextTag();
        }
        return result;
    }

    public static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != XmlPullParser.START_TAG) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case XmlPullParser.END_TAG:
                    depth--;
                    break;
                case XmlPullParser.START_TAG:
                    depth++;
                    break;
            }
        }
    }
}
