package com.yc.rss.radio;

import android.app.Activity;
import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.app.NotificationCompat;
import android.util.Log;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.ArrayAdapter;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Spinner;
import android.graphics.drawable.Drawable;
import android.widget.Toast;

import org.xmlpull.v1.XmlPullParserException;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MainActivity extends AppCompatActivity {
    private ImageView mImageView;
    private ImageView mCoverView;
    private TextView mTextView;
    private TextView mTextViewArtist;
    private TextView mTextViewTitle;
    public static String articles;
    private Spinner spinArticle;
    private List<Entry> entries = null;
    public List<EntryTag> entries_tag = null;
    private int entries_sz = -1;
    public int entries_tag_sz = -1;
    private ProgressDialog pDialog;
    private DownloadFileFromURL mDownloadTags = null;
    private DownloadCoverFromURL mDownloadCover = null;
    private MediaPlayer mediaPlayer = null;
    private int current_pos = -1;
    private boolean initialState = true;
    private boolean initialNoTag = true;
    private static final int RADIO_NOTIFICATION=9999;
    public static final String ACTION_1 = "action_1";
    public static final String ACTION_2 = "action_2";
    public static final String ACTION_3 = "action_3";
    public static final String ACTION_4 = "action_4";

    private String old_title="";
    private String old_artist="";
    final Intent intentClick = null;

    public List<EntryTag> getTags() {
        return entries_tag;
    }

    private Handler iSender = new Handler() {
        @Override
        public void handleMessage(final Message msg) {
            System.out.println("iSender");
            mDownloadTags = (DownloadFileFromURL) new DownloadFileFromURL().execute(getString(R.string.tags_url));
            iSender.sendEmptyMessageDelayed(0, 30*1000);
        }
    };

    class DownloadFileFromURL extends AsyncTask<String, String, String> {
        private String page_content;

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            System.out.println("Starting download");
            /*
            pDialog = new ProgressDialog(MainActivity.this);
            pDialog.setMessage("Loading... Please wait...");
            pDialog.setIndeterminate(false);
            pDialog.setCancelable(false);
            pDialog.show();
            */
        }

        @Override
        protected String doInBackground(String... f_url) {
            int count;
            try {
                URL url = new URL(f_url[0]);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setReadTimeout(10000 /* milliseconds */);
                conn.setConnectTimeout(15000 /* milliseconds */);
                conn.setRequestMethod("GET");
                conn.setDoInput(true);
                conn.connect();
                InputStream stream = conn.getInputStream();
                StringBuilder page_content_builder = new StringBuilder();
                byte data[] = new byte[65536];
                while ((count = stream.read(data)) != -1) {
                    String str = new String(data, "UTF-8");
                    page_content_builder.append(str);
                }
                page_content = page_content_builder.toString();
            } catch (Exception e) {
                Log.e("Error: ", e.getMessage());
            }
            return null;
        }

        @Override
        protected void onPostExecute(String file_url) {
            System.out.println("Downloaded");
            //pDialog.dismiss();
            try {
                TagsXmlParser tagsXmlParser = new TagsXmlParser();
                InputStream stream = new ByteArrayInputStream(page_content.getBytes(StandardCharsets.UTF_8));
                entries_tag = tagsXmlParser.parse(stream);
                entries_tag_sz = entries_tag.size();
            } catch (IOException ignored) {
                entries_tag = null;
                entries_tag_sz = -1;
            } catch (XmlPullParserException ignored) {
                entries_tag = null;
                entries_tag_sz = -1;
            }
            if(true == initialNoTag ) {
                initialNoTag = false;
                ToastThis(getString(R.string.tags_downloaded));
            }
            ExtUpdate();
        }
    }

    class DownloadCoverFromURL extends AsyncTask<String, String, String> {
        private String page_content;
        private int pos;

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            System.out.println("Starting Cover download");
        }

        @Override
        protected String doInBackground(String... f_url) {
            int count;
            try {
                pos = Integer.parseInt(f_url[0]);
                URL url = new URL(f_url[1]);
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setReadTimeout(10000 /* milliseconds */);
                conn.setConnectTimeout(15000 /* milliseconds */);
                conn.setRequestMethod("GET");
                conn.setDoInput(true);
                conn.connect();
                InputStream stream = conn.getInputStream();
                StringBuilder page_content_builder = new StringBuilder();
                byte data[] = new byte[65536];
                while ((count = stream.read(data)) != -1) {
                    String str = new String(data, "UTF-8");
                    page_content_builder.append(str);
                }
                page_content = page_content_builder.toString();
            } catch (Exception e) {
                Log.e("Error: ", e.getMessage());
            }
            return null;
        }

        @Override
        protected void onPostExecute(String file_url) {
            System.out.println("Cover Downloaded");
            List<EntryTag> entries_tag = getTags();
            EntryTag entry_tag = entries_tag.get(pos);
            entry_tag.cover = page_content;
            //ExtUpdate();
            InputStream stream = new ByteArrayInputStream(page_content.getBytes(StandardCharsets.UTF_8));
            //Bitmap bitmap = BitmapFactory.decodeStream(stream);
            //mCoverView.setImageBitmap(bitmap);
            Drawable d = Drawable.createFromStream(stream, null);
            mImageView.setImageDrawable(d);

        }
    }

    class Player extends AsyncTask<String, Void, Boolean> {
        private ProgressDialog progress;

        @Override
        protected Boolean doInBackground(String... params) {
            // TODO Auto-generated method stub
            Boolean prepared;
            try {

                mediaPlayer.setDataSource(params[0]);

                mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {

                    @Override
                    public void onCompletion(MediaPlayer mp) {
                        // TODO Auto-generated method stub
//                        playPause=false;
//                        btn.setBackgroundResource(R.drawable.button_play);
                        mediaPlayer.stop();
                        mediaPlayer.reset();
                    }
                });
                mediaPlayer.prepare();
                prepared = true;
            } catch (IllegalArgumentException e) {
                // TODO Auto-generated catch block
                Log.d("IllegarArgument", e.getMessage());
                prepared = false;
                e.printStackTrace();
            } catch (SecurityException e) {
                // TODO Auto-generated catch block
                prepared = false;
                e.printStackTrace();
            } catch (IllegalStateException e) {
                // TODO Auto-generated catch block
                prepared = false;
                e.printStackTrace();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                prepared = false;
                e.printStackTrace();
            }
            return prepared;
        }

        @Override
        protected void onPostExecute(Boolean result) {
            // TODO Auto-generated method stub
            super.onPostExecute(result);
            if (progress.isShowing()) {
                progress.cancel();
            }
            Log.d("Prepared", "//" + result);
            mediaPlayer.start();
        }

        public Player() {
            progress = new ProgressDialog(MainActivity.this);
        }

        @Override
        protected void onPreExecute() {
            // TODO Auto-generated method stub
            super.onPreExecute();
            this.progress.setMessage("Buffering...");
            this.progress.show();

        }
    }

    public void ToastThis(String message) {
        Toast.makeText(this,
                message,
                Toast.LENGTH_SHORT).show();
    }

    public static Bitmap drawableToBitmap (Drawable drawable) {
        Bitmap bitmap = null;

        if (drawable instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
            if(bitmapDrawable.getBitmap() != null) {
                return bitmapDrawable.getBitmap();
            }
        }

        if(drawable.getIntrinsicWidth() <= 0 || drawable.getIntrinsicHeight() <= 0) {
            bitmap = Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888); // Single color bitmap will be created of 1x1 pixel
        } else {
            bitmap = Bitmap.createBitmap(drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
        }

        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public void Notify(String shortname, String notificationTitle, String notificationMessage){
        /*AssetManager am = getAssets();
        try {
            InputStream ims = am.open(shortname + ".jpg");
            Drawable d = Drawable.createFromStream(ims, null);
            mNotifBuilder.setLargeIcon(drawableToBitmap(d));
        } catch (IOException e) {
            mNotifBuilder.setSmallIcon(R.drawable.ic_notification);
        }
        */

        //mNotifBuilder.setSmallIcon(this.getResources().getIdentifier(shortname, "drawable", this.getPackageName()));

        /*
        Notification.Builder mBuilder =
                new Notification.Builder(this)
                        .setSmallIcon(this.getResources().getIdentifier(shortname, "drawable", this.getPackageName()))
                        .setContentTitle("CoderoMusicPlayer")
                        .setContentText("PLayer0!");
        */
        Notification.Builder mBuilder = new Notification.Builder(this);
        mBuilder.setSmallIcon(this.getResources().getIdentifier(shortname, "drawable", this.getPackageName()));
        if (android.os.Build.VERSION.SDK_INT <= Build.VERSION_CODES.LOLLIPOP) {
            mBuilder.setContentTitle(notificationTitle);
            mBuilder.setContentText(notificationMessage);
        } else {
            mBuilder.setContentTitle(notificationTitle);
            mBuilder.setContentText(notificationMessage + "\n" + notificationTitle);
            mBuilder.setColor(this.getResources().getColor(android.R.color.white));
        }

        mBuilder.setOngoing(true);

        Intent resultIntent = new Intent(this, MainActivity.class);
        resultIntent.setAction(Intent.ACTION_MAIN);
        resultIntent.addCategory(Intent.CATEGORY_LAUNCHER);

        PendingIntent pendingIntent = PendingIntent.getActivity(this, 0,
                resultIntent, 0);

        mBuilder.setContentIntent(pendingIntent);
        NotificationManager mNotificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
        mNotificationManager.notify(9999, mBuilder.build());
    }

    public void NotifyClear(){
        NotificationManager notificationManager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
        notificationManager.cancel(RADIO_NOTIFICATION);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        iSender.sendEmptyMessage(0);
        mediaPlayer = new MediaPlayer();
        mediaPlayer.setAudioStreamType(AudioManager.STREAM_MUSIC);

        new Thread(new Runnable() {
            @Override
            public void run() {
                try {
                    Thread.sleep(5000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {

                    }
                });
            }
        }).start();

        setContentView(R.layout.activity_main);
        mImageView = (ImageView)findViewById(R.id.imageView);
        mCoverView = (ImageView)findViewById(R.id.imageViewTrack);
        mTextView = (TextView) findViewById(R.id.textView);
        mTextViewArtist = (TextView) findViewById(R.id.textViewArtist);
        mTextViewTitle = (TextView) findViewById(R.id.textViewTitle);
        spinArticle = (Spinner) findViewById(R.id.spinner_article);
        addListenerOnSpinnerItemSelection();
    }

    public void ExtUpdate() {
        int pos = spinArticle.getSelectedItemPosition();
        if( current_pos != pos ) {
            NotifyClear();
            if (mediaPlayer.isPlaying()) {
                mediaPlayer.stop();
            }
        }

        try {
            if( -1 == entries_sz ) {
                FeedParser();
            }
            AssetManager am = getAssets();
            String resourcefilename=entries.get(pos).shortname;
            //InputStream ims = am.open(resourcefilename+".jpg");
            InputStream ims = am.open(resourcefilename+".png");
            Drawable d = Drawable.createFromStream(ims, null);
            mImageView.setImageDrawable(d);
            if(null== entries_tag) {
                mTextView.setText(entries.get(pos).title);
                mCoverView.setImageDrawable(d);
            } else {
                mTextView.setText(entries_tag.get(pos).title);
                //mTextViewTitle.setText(entries_tag.get(pos).track_title);
                if(! entries_tag.get(pos).track_title.equals("An Error Occured")) {
                    mTextViewTitle.setText(entries_tag.get(pos).track_title);
                } else {
                    mTextViewTitle.setText("");
                }
                //mTextViewArtist.setText(entries_tag.get(pos).track_artist);
                if(! entries_tag.get(pos).track_artist.equals("An Error Occured")) {
                    mTextViewArtist.setText(entries_tag.get(pos).track_artist);
                } else {
                    mTextViewArtist.setText("");
                }
                if( (!old_artist.equals(mTextViewArtist.getText().toString())) ||
                        (!old_title.equals(mTextViewTitle.getText().toString())) ) {
                    Notify(entries.get(pos).shortname,
                            mTextViewArtist.getText().toString(),
                            mTextViewTitle.getText().toString());
                    old_artist = mTextViewArtist.getText().toString();
                    old_title = mTextViewTitle.getText().toString();
                }
                /*
                if(! entries_tag.get(pos).track_url.equals("")) {
                    System.out.println(entries_tag.get(pos).track_url);
                    if (null != entries_tag.get(pos).cover) {
                        InputStream stream = new ByteArrayInputStream(entries_tag.get(pos).cover.getBytes(StandardCharsets.UTF_8));
                        d = Drawable.createFromStream(stream, null);
                        mCoverView.setImageDrawable(d);
                    } else {
                        mDownloadCover = (DownloadCoverFromURL) new DownloadCoverFromURL().execute(Integer.toString(pos),entries_tag.get(pos).track_url);
                    }
                } else {
                    mCoverView.setImageDrawable(d);
                }*/
                mCoverView.setImageDrawable(d);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        Log.d("ExtUpdate DEBUG:", "Start Playing");
        if( current_pos != pos ) {
            current_pos = pos;
            mediaPlayer = new MediaPlayer();
            new Player().execute(entries.get(pos).mp3);
            if( entries_tag != null ) {
                if (entries_tag.get(pos) != null) {
                    if ((null != entries_tag.get(pos).track_artist) &&
                            (null != entries_tag.get(pos).track_artist)) {
                        Notify(entries.get(pos).shortname, entries_tag.get(pos).track_artist, entries_tag.get(pos).track_title);
                    } else {
                        Notify(entries.get(pos).shortname, entries.get(pos).title, getString(R.string.tags_not_found));
                    }
                } else {
                    Notify(entries.get(pos).shortname, entries.get(pos).title, getString(R.string.tags_not_found));
                }
            } else {
                Notify(entries.get(pos).shortname, entries.get(pos).title, getString(R.string.tags_not_dl));
            }
        }
    }

    public void addListenerOnSpinnerItemSelection(){
        spinArticle.setOnItemSelectedListener(new SpinnerActivity());
    }

    @Override
    public boolean onSupportNavigateUp(){
        finish();
        return true;
    }

    public boolean updateListView() {
        boolean ret = false;
        String [] items1 = null;
        ArrayList al = new ArrayList<String>();
        try {
            items1 = doDropDown();
        } catch( Exception e ) {
            return ret;
        }

        ArrayAdapter<String> adapter1 = new ArrayAdapter<String>(this,
                android.R.layout.simple_spinner_item, items1);
        adapter1.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spinArticle.setAdapter(adapter1);
        adapter1.notifyDataSetChanged();
        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        MenuItem menuItemDateRefresh = menu.findItem(R.id.last_refresh_date);
        menuItemDateRefresh.setTitle(getString(R.string.version));
        return true;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_exit) {
            NotifyClear();
            if (mediaPlayer.isPlaying()) {
                mediaPlayer.stop();
            }
            finish();
            System.exit(0);
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    private void FeedParser() {
        RadioXmlParser radioXmlParser = new RadioXmlParser();
        InputStream stream = null;
        AssetManager am = getAssets();
        try {
            stream = am.open("radio.xml");
            try {
                entries = radioXmlParser.parse(stream);
                entries_sz = entries.size();
                updateListView();
                invalidateOptionsMenu();
                if( initialState == true ) {
                    initialState = false;
                    spinArticle.setSelection(0, true);
                }
            } catch (IOException ignored) {
                entries = null;
                entries_sz = -1;
            } catch (XmlPullParserException ignored) {
                entries = null;
                entries_sz = -1;
            }
            if (null != stream) {
                try {
                    stream.close();
                } catch (IOException e) {
                }
            }

        } catch (IOException e) {
            e.printStackTrace();
            entries = null;
            entries_sz = -1;
        }
    }

    /** Feed 2 Article list for Spinner */
    private String[] doDropDown() throws IOException {
        String[] strings;
        if( -1 == entries_sz ) {
            FeedParser();
        }

        HashSet<String> hs = new HashSet<String>();
        List<String> mStrings = new ArrayList<String>();
        int i = 0;
        for( i = 0; i < entries_sz; i ++ )
        {
            Entry temp = entries.get(i);
            mStrings.add(i,temp.title);
        }
        mStrings.addAll(hs);
        strings = new String[mStrings.size()];
        strings = mStrings.toArray(strings);
        return strings;
    }
}
