# LoRaWAN Frame decoder

Simple tools to decode MAC commands and Join messages

Work in progress

# maccommands

## Python

### Usage

```
$ ./maccommands.py --help
usage: maccommands.py [-h] -d DATA [--direction DIRECTION]

Parse LoRaWAN MAC Commands

optional arguments:
  -h, --help            show this help message and exit
  -d DATA, --data DATA  MAC payload in hex string
  --direction DIRECTION
                        uplink: 0, downlink: 1
```

### Example

```
$ ./maccommands.py --direction 1 -d 0a00d0248d0a01a02c8d0a0270348d0a03403c8d
DL : 0a00d0248d0a01a02c8d0a0270348d0a03403c8d
  CID: 0x0A : Name: DlChannelReq
    Raw: 00d0248d
    Data:
     ChIndex: 0
     Frequency: 925000000
  CID: 0x0A : Name: DlChannelReq
    Raw: 01a02c8d
    Data:
     ChIndex: 1
     Frequency: 925200000
  CID: 0x0A : Name: DlChannelReq
    Raw: 0270348d
    Data:
     ChIndex: 2
     Frequency: 925400000
  CID: 0x0A : Name: DlChannelReq
    Raw: 03403c8d
    Data:
     ChIndex: 3
     Frequency: 925600000
--------------
```

## JavaScript

File **index.html** shows a small webpage example for MAC commands decoding using **maccommands.js**.

# lora-decode

Decoding is a working progress

## Usage

```
$ ./lora-decode.py --help
usage: lora-decode.py [-h] -d DATA [--appkey APPKEY] [--clear]

Parse a LoRaWAN PHYPayload.

optional arguments:
  -h, --help            show this help message and exit
  -d DATA, --data DATA  LoRaWAN payload in hex string
  --appkey APPKEY       AppKey (hex) to decrypt Join Accept
  --clear               Treat Join Accept as already decrypted (cleartext)
```

## Example

```
$ ./lora-decode.py -d 201c0000020000068b03040201b8ab8c88b38c58bb8c28c38cf8ca8c006db0d77f --clear
MHDR:
  MHDR Byte: 0x20
  MType: Join Accept
  Major: 0 (LoRaWAN v1.0)

Frame Type: Join Accept
Fields:
  AppNonce: 00001c
  NetID: 000002
  DevAddr: 04038b06
  DLSettings: 0x2
  RxDelay: 1
  CFList: b8ab8c88b38c58bb8c28c38cf8ca8c00
  MIC: 6db0d77f
```


