<?php
require_once('sources/rss.php');
//List available images
$newslist = array();
$imagelist = array();
$contentlist = array();
$content = file_get_contents("sources/news.json");
$newsdetails = json_decode($content,true);
foreach( $newsdetails as $news ) {
  array_push($newslist, $news['name']);
  array_push($imagelist, $news['image']);
  array_push($contentlist, $news['html']);
}

function NewsSection($sourceHTML) {
  $html="";
  $html .= '<div class="col-4 col-s-8">'.PHP_EOL;
  $content = file_get_contents($sourceHTML);
  $html .= $content;
  $html .= '</div>'.PHP_EOL;
  
  return $html;
}
?>
<!doctype html>
<html lang="en-us">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="favicon.png">
    <link href="css/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">
    <link rel="stylesheet" type="text/css" href="css/style.css" />
    <link rel="alternate stylesheet" type="text/css" id="style-dynamic" href="" />
    <script src="jspdf.min.js"></script>
    <script>
    function downloadInnerHtml(filename, elId, mimeType) {
        //var elHtml = document.getElementById(elId).innerHTML;
        var elHtml = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" />'; 
        elHtml += '<meta name="viewport" content="width=device-width, initial-scale=1.0">';
        elHtml += '<style>';
        elHtml += 'html { font-family: "Lucida Sans", sans-serif; }'; 
        elHtml += 'img { width: 80%; margin-left: auto; margin-right: auto; }';
        elHtml += '.img-conspiracy { width: 50%; margin-left: 30%; margin-right: auto; }';
        elHtml += 'iframe { width: 80%; margin-left: auto; margin-right: auto; }';
        elHtml += '</style>';
        elHtml += '</head><body>';
        elHtml += document.getElementById(elId).innerHTML;
        elHtml += '</body><html>';
        var link = document.createElement('a');
        mimeType = mimeType || 'text/plain';
        link.setAttribute('download', filename);
        link.setAttribute('href', 'data:' + mimeType  +  ';charset=utf-8,' + encodeURIComponent(elHtml));
        link.click(); 
    }
    function changeCSS(cssFile, cssLinkIndex) {
      var oldlink = document.getElementsByTagName("link").item(cssLinkIndex);
      var newlink = document.createElement("link");
      newlink.setAttribute("rel", "stylesheet");
      newlink.setAttribute("type", "text/css");
      newlink.setAttribute("href", cssFile);
      document.getElementsByTagName("head").item(0).replaceChild(newlink, oldlink);
    }
    function getStylesheet() {
      var currentTime = new Date().getHours();
      if (0 <= currentTime && currentTime < 8) {
        changeCSS('css/style-night.css',3);
      } else if (8 <= currentTime && currentTime < 19) {
        changeCSS('css/style-day.css',3);
      } else if (19 <= currentTime && currentTime < 24) {
        changeCSS('css/style-night.css',3);
      }
    }
    getStylesheet();

    </script>
    <script>
    function onArticle(index) {
      var string_index = "article-"+index;
      var url = location.href;
      var x = document.getElementById("item-active");
      x.className = string_index;
      document.getElementById("article-current").innerHTML =
        document.getElementById(string_index).innerHTML;
      location.href = "#article-top";
    }
    </script>
    <script>
    function hideMenu() {
      var x = document.getElementById("menu-news");
      var btn = document.getElementById("menu-btn");
      if (x.style.display === "none") {
        x.style.display = "block";
        btn.innerHTML = '<i class="fa fa-times fa-fw"></i>';
        document.getElementById('article-display').setAttribute("class", "col-6");
      } else {
        x.style.display = "none";
        btn.innerHTML = '<i class="fa fa-bars fa-fw"></i>';
        document.getElementById('article-display').setAttribute("class", "col-8");
      }
    }
    function forceStylesheet() {
      var x = document.getElementById("style-active");
      var btn = document.getElementById("style-btn");

      if (x.className === "night") {
        x.className = "day";
        btn.innerHTML = '<i class="fa fa-sun-o fa-fw"></i>';
        changeCSS('css/style-day.css',3);
      } else {
        x.className = "night";
        btn.innerHTML = '<i class="fa fa-moon-o fa-fw"></i>';
        changeCSS('css/style-night.css',3);
      }
    }

    window.onload = function () {
      // Set Day/Night icon after load
      var x = document.getElementById("style-active");
      var btn = document.getElementById("style-btn");
      var currentTime = new Date().getHours();
      if (0 <= currentTime && currentTime < 8) {
        x.className = "night";
        btn.innerHTML = '<i class="fa fa-moon-o fa-fw"></i>';
        changeCSS('css/style-night.css',3);
      } else if (8 <= currentTime && currentTime < 19) {
        x.className = "day";
        btn.innerHTML = '<i class="fa fa-sun-o fa-fw"></i>';
        changeCSS('css/style-day.css',3);
      } else if (19 <= currentTime && currentTime < 24) {
        x.className = "night";
        btn.innerHTML = '<i class="fa fa-moon-o fa-fw"></i>';
        changeCSS('css/style-night.css',3);
      }
      var w = window;
      var d = document;
      var e = d.documentElement;
      var g = d.getElementsByTagName('body')[0];
      screenX = w.innerWidth || e.clientWidth || g.clientWidth;
      if(screenX > 767) {
        var sectionMenu = document.getElementById("menu-news");
        sectionMenu.style.display = "none";
      }
      hideMenu();
    }
    </script>
    <title><?php echo NEWS_TITLE; ?></title>
  </head>
  <body>
    <div class="row">
    <div class="col-12 col-s-12">
      <div class="header">
          <span id="style-active" class="day"></span>
          <span id="item-active" class="-1"></span>
          <button id="menu-btn" onclick="hideMenu()"><i class="fa fa-times fa-fw"></i></button>      
          <button id="style-btn" onclick="forceStylesheet()"><i class="fa fa-sun-o fa-fw"></i></button>      
          <!-- <button id="downloadPDF" onclick="printPDF()"><i class="far fa-file-pdf fa-fw"></i></button> -->
          <button id="html-btn" onclick="printHTML()"><img src="img/html5.png" width="24px" height="24px"></button>
          <button id="pdf-btn" onclick="printPDF()"><img src="img/pdf.png" width="24px" height="24px"></button>
          <h1 style="display: inline"><i class="fa fa-newspaper-o fa-fw"></i> <?php echo NEWS_TITLE; ?></h1>
      </div>
    </div><!-- ./col-11 -->
    </div><!-- ./row -->

    <div class="row">
    <div id="menu-news" class="col-2 col-s-2 menu">
      <ul>
<?php
  $cpt = 0;
  foreach  ( $imagelist as $file ) {
    echo '         <li><i class="fa fa-newspaper-o fa-fw"></i><a href="?channel='.$file.'">'.$newslist[$cpt].'</a></li>'.PHP_EOL;
    $cpt++;
  }
?>
      </ul>
    </div>
    <!-- Main Display -->
<?php
  //Default is first of the list
  $GETchannel = $imagelist[0];
  $GETcontent = $contentlist[0];
  $cpt = 0;
  if( isset( $_GET['channel'] ) ) {
    $GETchannel = $_GET['channel'];
    $cpt = 0;
    foreach  ( $imagelist as $newsName ) {
      if( $newsName ==  $GETchannel ) {
        break;
      }
      $cpt++;
    }
  }

  $GETcontent = $contentlist[$cpt];
  echo NewsSection($GETcontent);
?>

    </div>
    </div> <!-- ./row -->
    <script>
    function printHTML() {
      var filename = 'test.html'
      downloadInnerHtml(filename, 'article-current','text/html');
    }
    function printPDF() {
      var filename = 'test.pdf'
      var margin = { top: 0, left: 10, right: 0, bottom: 0 };
      var printDoc = new jsPDF();
      var content = '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" />';
      content += '<link rel="stylesheet" type="text/css" href="css/style.css" />';
      content += '</head><body>';
      content += '<h1>'+window.location.href+'</h1><hr><p><em>Dirty PDF export</em></p>';
      var x = document.getElementById("item-active");
      content += document.getElementById(x.className).innerHTML;
      content += '</body></html>';
      printDoc.fromHTML(content, 10, 10, { 'width': 100 },
        function(bla){printDoc.save(filename);});
    }
    </script>
  </body>
</html>
