<?php
include_once( 'news-constants.php' );

$rss_content = file_get_contents(NEWS_RSS_AJE);
$xml = simplexml_load_string($rss_content);
if ($xml === false) {
  echo 'Failed to read RSS';
} else {
  $channel = array();
  $channel['title'] = $xml->channel->title;
  $channel['link'] = $xml->channel->link;
  $channel['description'] = $xml->channel->description;
  $channel['pubDate'] = $xml->channel->pubDate;
  $channel['timestamp'] = strtotime($xml->channel->pubDate);
  echo '<h4>' . $channel['title'] . '</h4>';
  $cpt=0;
  foreach ($xml->channel->item as $item) {
    $article = array();
    $article['title'] = $item->title;
    $article['link'] = $item->link;
    $article['pubDate'] = $item->pubDate;
    $article['timestamp'] = strtotime($item->pubDate);
    $article['description'] = $item->description;
    $article['image']=$item->mediacontent['url'];
    $articles[$cpt] = $article;
    echo '<div onclick="onArticle('.$cpt.')" style="display:inline;">';
    echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;';
    echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-down fa-2x"></i></a></div>&nbsp;';
    echo $article['title'].'&nbsp;&nbsp;';
    echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a><br></div></div>';
    $cpt++;
    if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
    }
  }
}
echo '</div><!-- ./col-4 -->'.PHP_EOL;
echo '<div id="article-display" class="col-6">'.PHP_EOL;
echo '<a name="article-top"></a><div id="article-current"></div>'.PHP_EOL;
echo '</div><!-- ./col-6 -->'.PHP_EOL;

$cpt=0;
foreach ($articles as $article ) {
  $cpt_prev=$cpt-1;
  $cpt_next=$cpt+1;
  echo '<!-- ==================== article '.$cpt.'============== -->';
  echo "<div class=\"article\" id=\"article-$cpt\" style=\"display: none;\">\n";
  echo "<hr>";
  echo "<a name=\"article-$cpt\">";
  $article_content = file_get_contents($article['link']);
  $doc = new DOMDocument();
  $doc->preserveWhiteSpace = false;
  $doc->formatOutput       = true;
  $libxml_previous_state = libxml_use_internal_errors(true);
  $doc->loadHTML($article_content);
  libxml_clear_errors();
  libxml_use_internal_errors($libxml_previous_state);
  $articles = $doc->getElementsByTagName('article');
  $article_only="";
  foreach ( $articles as $node) {
    $article_only = DOMinnerHTML($node);
  }

  $orgStrings = array(' href="/', ' src="/');
  $newStrings = array(' href="https://www.aljazeera.com/', ' src="https://www.aljazeera.com/');
  $article_only  = str_replace($orgStrings, $newStrings, $article_only);

	//Clean some sections
	//$article_only = re_remove($article_only, '//');
	$article_only = re_remove($article_only, '/<div id="(.+?)-slug" class="ResponsiveAd-(.+?)"><p>Advertisement<\/p><\/div>/');
	$article_only = re_remove($article_only, '/<aside class="css-(.+?)"><span><\/span><\/aside>/');
	$article_only = re_remove($article_only, '/<li class="css-(.+?)">(.+?)<\/li>/');
	$article_only = re_remove($article_only, '/<svg(.+?)>(.+?)<\/svg>/');
	$article_only = re_remove($article_only, '/<button id="desktop-sections-button" (.+?)>(.+?)<\/button>/');
	//$article_only = re_remove($article_only, '/<div role="toolbar" aria-label="Social Media Share buttons, Save button, and Comments Panel with current comment count" class="css-(.+?)" data-testid="share-tools">/');
	$article_only = re_remove($article_only, '/<div id="sponsor-slug" (.+?)><p>Supported by<\/p><\/div>/');
	$article_only = re_remove($article_only, '/<div class="ad top-wrapper" style="text-align:center;height:100%;display:block;min-height:250px"><div id="top"><\/div><\/div>/');
	$article_only = re_remove($article_only, '/<div class="ad sponsor-wrapper" style="text-align:center;height:100%;display:block"><div id="sponsor"><\/div><\/div>/');

	//Some little replacements
	$re = '/<div id="top-wrapper" class="ResponsiveAd-(.+?)">/';
	$article_only = preg_replace($re, '<div>', $article_only);
	$re = '/<time class="css-(.+?)>(.+?)<\/time>/';
	$article_only = preg_replace($re, '<time>\2</time>', $article_only);
	$re = '/<p class="css-(.+?) (.+?)">/';
	$article_only = preg_replace($re, '<p>', $article_only);
	$re = '/<h1 class=(.+?)><span>(.+?)<\/span><\/h1>/';
	$article_only = preg_replace($re, '<h1>\2</h1>', $article_only);
	$re = '/<h3 class=(.+?)>(.+?)<\/h3>/';
	$article_only = preg_replace($re, '<h3>\2</h3>', $article_only);
	$re = '/<div class="css-(.+?) StoryBodyCompanionColumn">/';
	$article_only = preg_replace($re, '<div>', $article_only);
	$re = '/<div class="css-(.+?)">/';
	$article_only = preg_replace($re, '<div>', $article_only);
	$re = '/<div><h2 class=(.+?)>(.+?)<\/h2><\/div>/';
	$article_only = preg_replace($re, '<h2>\2</h2>', $article_only);
	$re = '/<div role="toolbar" aria-label="Social Media Share buttons, Save button, and Comments Panel with current comment count" class="css-(.+?)" data-testid="share-tools">/';
	$article_only = preg_replace($re, '<div>', $article_only);


	$article_only = preg_replace('/<li class="css-(.+?)"><div><ul class="css-(.+?)">/', '<li>', $article_only);
	$article_only = preg_replace('/<\/ul><\/div><\/li>/', '</li>', $article_only);
	$article_only = re_remove($article_only, '/<div><button aria-haspopup="true" aria-expanded="false" (.+?)><\/button><\/div>/');
	$article_only = re_remove($article_only, '/<a class="css-(.+?)" href="#site-content">Skip to content<\/a><a class="css-(.+?)" href="#site-index">Skip to site index<\/a>/');

	//Finally remove empty lines
	$article_only = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $article_only);
  
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div>';
  echo '<div class="extract-content" id="'.$cpt.'">'.'<h1>'.$article['title'].'</h1>'.$article_only.'</div>';
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-up fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div></div>';
  $cpt++;
  if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
  }
}
?>


