<?php
include_once( 'news-constants.php' );

$rss_content = file_get_contents(NEWS_RSS_BBC);
$xml = simplexml_load_string($rss_content);
if ($xml === false) {
  echo 'Failed to read RSS';
} else {
  $channel = array();
  $channel['title'] = $xml->channel->title;
  $channel['link'] = $xml->channel->link;
  $channel['description'] = $xml->channel->description;
  $channel['pubDate'] = $xml->channel->pubDate;
  $channel['timestamp'] = strtotime($xml->channel->pubDate);
  echo '<h4>' . $channel['title'] . '</h4>';
  $cpt=0;
  foreach ($xml->channel->item as $item) {
    $article = array();
    $article['title'] = $item->title;
    $article['link'] = $item->link;
    $article['pubDate'] = $item->pubDate;
    $article['timestamp'] = strtotime($item->pubDate);
    $article['description'] = $item->description;
    $articles[$cpt] = $article;
    echo '<div onclick="onArticle('.$cpt.')" style="display:inline;">';
    echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;';
    echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-down fa-2x"></i></a></div>&nbsp;';
    echo $article['title'].'&nbsp;&nbsp;';
    echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a><br></div></div>';
    $cpt++;
    if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
    }
  }
}

echo '</div><!-- ./col-4 -->'.PHP_EOL;
echo '<div id="article-display" class="col-6">'.PHP_EOL;
echo '<a name="article-top"></a><div id="article-current"></div>'.PHP_EOL;
echo '</div><!-- ./col-6 -->'.PHP_EOL;

$cpt=0;
foreach ($articles as $article ) {
  $cpt_prev=$cpt-1;
  $cpt_next=$cpt+1;
  echo '<!-- ==================== article '.$cpt.'============== -->';
  echo "<div class=\"article\" id=\"article-$cpt\" style=\"display: none;\">\n";
  echo "<hr>";
  echo "<a name=\"article-$cpt\">";
  $article_content = file_get_contents($article['link']);
  //DEBUG
  $doc = new DOMDocument();
  $doc->preserveWhiteSpace = false;
  $doc->formatOutput       = true;
  $libxml_previous_state = libxml_use_internal_errors(true);
  $doc->loadHTML($article_content);
  libxml_clear_errors();
  libxml_use_internal_errors($libxml_previous_state);
  $articles = $doc->getElementsByTagName('div');
  $article_only="";
  $section_found = false;
  foreach ( $articles as $node) {
    if(0==strcmp("story-body",$node->getAttribute('class'))) {
      $article_only = DOMinnerHTML($node);
      $section_found = true;
      break;
    }
  }

  if(false == $section_found ) {
    $article_only = "Section Not Found";
    foreach ( $articles as $node) {
      if(0==strcmp("vxp-media__body",$node->getAttribute('class'))) {
        $article_only = "<p>Video</p>".DOMinnerHTML($node);
        $section_found = true;
        break;
      }
    }
  }

  //Clean some sections
	//$article_only = re_remove($article_only, '//');
	$article_only = re_remove($article_only, '/<div id="topic-tags"><div id="(.+?)"><noscript><\/noscript><\/div><\/div>/');
	$article_only = re_remove($article_only, '/<svg class="extracted-svg ex-(.+?)" (.+?)<\/path><\/g><\/svg>/');
	$article_only = re_remove($article_only, '/<svg class="twite__share-icon" (.+?)<\/svg>/');
	$article_only = re_remove($article_only, '/<span class="twite__icon twite__icon--(.+?)" data-platform="(.+?)"><\/span>/');
	$article_only = re_remove($article_only, '/<p class="twite__channel-(.+?)" aria-hidden="true">(.+?)<\/p>/');
	$article_only = re_remove($article_only, '/<span class="off-screen">Share this (.+?)<\/span>/');
  $article_only = re_remove($article_only, '/                    <span class="extracted__icon extracted__icon--(.+?)" data-platform="(.+?)">/');
	$article_only = re_remove($article_only, '/                    <\/span>/');
	$article_only = re_remove($article_only, '/<p class="twite__copy-text">Copy this link<\/p>/');
	$article_only = re_remove($article_only, '/<span class="off-screen">Close share panel<\/span>/');
	$article_only = re_remove($article_only, '/<div class="twite__close-button-graphic" aria-hidden="true"><\/div>/');
	$article_only = re_remove($article_only, '/if \(window.bbcdotcom && bbcdotcom.adverts && bbcdotcom.adverts.slotAsync\) /');
	$article_only = re_remove($article_only, '/bbcdotcom.adverts.slotAsync\(\'mpu\', \[1,2,3\]\);/');

  
  //$article_only = preg_replace('//', '', $article_only);
  $article_only = preg_replace('/<div class="with-extracted-share-icons">/', '<div class="with-extracted-share-icons" style="display:none">', $article_only);
  $article_only = preg_replace('/<img class="js-image-replace" alt="(.+?)" src="(.+?)" width="(.+?)" height="(.+?)"><span class="off-screen">Image copyright<\/span>/', '<img src="\2"><br>Copyright ', $article_only);
  $article_only = preg_replace('/<a class="extracted__channel-link (.+?) tabindex="-1">/', '<a>', $article_only);
  $article_only = preg_replace('/<a class="twite__(.+?)-link" (.+?)>/', '<a>', $article_only);
  $article_only = preg_replace('/<li class="twite__channel-out (.+?)" aria-hidden="true">/', '<li>', $article_only);
  $article_only = preg_replace('/<li class="twite__channel twite__channel--(.+?) twite__channel-click--(.+?)">/', '<li>', $article_only);

  $re = '/<div class="vxp-media__share-tools"/';
  $article_only = preg_replace($re, '<div class="vxp-media__share-tools" style="display:none;">', $article_only);

	//Finally remove empty lines
	$article_only = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $article_only);
  
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div>';
  echo '<div class="extract-content" id="'.$cpt.'">'.$article_only.'</div>';
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-up fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div></div>';
  $cpt++;
  if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
  }
}
?>


