<?php
include_once( 'news-constants.php' );

$rss_content = file_get_contents(NEWS_RSS_CNA);
$orgStrings = array( 'media:content');
$newStrings = array( 'mediacontent');
$rss_content  = str_replace($orgStrings, $newStrings, $rss_content);
$xml = simplexml_load_string($rss_content);
if ($xml === false) {
  echo 'Failed to read RSS';
} else {
  $channel = array();
  $channel['title'] = $xml->channel->title;
  $channel['link'] = $xml->channel->link;
  $channel['description'] = $xml->channel->description;
  $channel['pubDate'] = $xml->channel->pubDate;
  $channel['timestamp'] = strtotime($xml->channel->pubDate);
  echo '<h4>' . $channel['title'] . '</h4>';
  $cpt=0;
  foreach ($xml->channel->item as $item) {
    $article = array();
    $article['title'] = $item->title;
    $article['link'] = $item->link;
    $article['pubDate'] = $item->pubDate;
    $article['timestamp'] = strtotime($item->pubDate);
    $article['description'] = $item->description;
    $articles[$cpt] = $article;
    echo '<div onclick="onArticle('.$cpt.')" style="display:inline;">';
    echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;';
    echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-down fa-2x"></i></a></div>&nbsp;';
    echo $article['title'].'&nbsp;&nbsp;';
    echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a><br></div></div>';
    $cpt++;
    if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
    }
  }
}

echo '</div><!-- ./col-4 -->'.PHP_EOL;
echo '<div id="article-display" class="col-6">'.PHP_EOL;
echo '<a name="article-top"></a><div id="article-current"></div>'.PHP_EOL;
echo '</div><!-- ./col-6 -->'.PHP_EOL;

$cpt=0;
foreach ($articles as $article ) {
  $cpt_prev=$cpt-1;
  $cpt_next=$cpt+1;
  echo '<!-- ==================== article '.$cpt.'============== -->';
  echo "<div class=\"article\" id=\"article-$cpt\" style=\"display: none;\">\n";
  echo "<hr>";
  echo "<a name=\"article-$cpt\">";
  $article_content = file_get_contents($article['link']);
  $doc = new DOMDocument();
  $doc->preserveWhiteSpace = false;
  $doc->formatOutput       = true;
  $libxml_previous_state = libxml_use_internal_errors(true);
  $doc->loadHTML($article_content);
  libxml_clear_errors();
  libxml_use_internal_errors($libxml_previous_state);  
  $articles = $doc->getElementsByTagName('article');
  $article_only="";
  foreach ( $articles as $node) {
    $article_only = DOMinnerHTML($node);
  }
  
  $SEARCH_SUB='<div class="c-save-for-later--default is-article-bottom-position"';
  $pos_start=strpos($article_only, $SEARCH_SUB);
  if($pos_start) {
    $article_only = substr($article_only,0,$pos_start);
  }

  //Extract image
  $re = '/<link rel="image_src" href="(.+?)"\/>/';
  preg_match($re, $article_content, $matches);
  $imageurl = $matches[1];

	//Clean some sections
	//$article_only = re_remove($article_only, '//');
	$article_only = re_remove($article_only, '/        <h2 class="sharing__title">/');
	$article_only = re_remove($article_only, '/                Share this content<\/h2>/');
	$article_only = re_remove($article_only, '/<button class="save-for-later__toggle i-save-for-later" data-js-atom="save-for-later-toggle" data-grunticon-embed="true" title="Bookmark article to read later"><\/button>/');
	$article_only = re_remove($article_only, '/<h2 class="save-for-later__title">Bookmark<\/h2>/');
	$article_only = re_remove($article_only, '/<div class="advertisement__container" data-js-atom="advertisement-wrapper" id="ad-outstream-desktop-news-story"><\/div>/');
	$article_only = re_remove($article_only, '/<div class="advertisement__container" data-js-atom="advertisement-wrapper" id="ad-imu1-desktop-news-story"><\/div>/');
	$article_only = re_remove($article_only, '/<div class="advertisement__container" data-js-atom="advertisement-wrapper" id="ad-imu1-mobile-news-story"><\/div>/');
	$article_only = re_remove($article_only, '/<div><\/div>/');
  $article_only = re_remove($article_only, '/<p><\/p>/');
	$article_only = re_remove($article_only, '/sizes="\(min-width: 992px\) 670px, 100vw"/');

  
	$article_only = preg_replace('/<figure class="picture__wrapper"><picture class="picture__container"><source data-srcset="(.+?)>(.+?)<\/source><\/picture>/', '<figure>', $article_only);
  $article_only = preg_replace('/<ul class="sharing__list">/', '<ul class="sharing__list" style="display:none">', $article_only);
  $article_only = preg_replace('/    <aside class="c-advertisement--rectangle is-hidden-tablet is-hidden-(.+?)"(.+?)><span class="advertisement__title">Advertisement<\/span>/', '<aside>', $article_only);
  $article_only = preg_replace('/<aside class="c-advertisement--rectangle-float (.+?)><span class="advertisement__title">Advertisement<\/span>/', '<aside>', $article_only);

	//Finally remove empty lines
	$article_only = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $article_only);
  
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div>';
  echo '<div class="extract-content" id="'.$cpt.'"><img src="'.$imageurl.'">'.$article_only.'</div>';
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-up fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div></div>';
  $cpt++;
  if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
  }
}
?>


