<?php
include_once( 'rss.php' );
$NEWS_RSS_MAX_ITEMS = 10;

function DOMinnerHTML(DOMNode $element) 
{ 
  $innerHTML = ""; 
  $children  = $element->childNodes;

  foreach ($children as $child) 
  { 
      $innerHTML .= $element->ownerDocument->saveHTML($child);
  }

  return $innerHTML; 
}

function http_get_contents($url, $opts = [])
{
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  curl_setopt($ch, CURLOPT_TIMEOUT, 10);
  curl_setopt($ch, CURLOPT_USERAGENT, "Wget 1");
  curl_setopt($ch, CURLOPT_URL, $url);
  if(is_array($opts) && $opts) {
    foreach($opts as $key => $val) {
      curl_setopt($ch, $key, $val);
    }
  }
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  if(FALSE === ($retval = curl_exec($ch))) {
    error_log(curl_error($ch));
  } else {
    return $retval;
  }
}

function re_remove($source, $regex) {
  return preg_replace($regex, '', $source);
}

function add_https($source, $seed) {
  $orgStrings = array( "http://$seed/" );
  $newStrings = array( "https://$seed/" );
  return str_replace($orgStrings, $newStrings, $source);
}

function dump2file($prefix, $index, $content) {
  $filename = "dump-".$prefix."-".$index.".html";
  file_put_contents($filename,$content);
}
?>
