#!/bin/bash
OUTDIR="/var/www/html/newsen/sources"
LOG_ENABLED=1
LOGFILE="$OUTDIR/gennews.log"

function log() {
  if [ 1 -eq $LOG_ENABLED ]
  then
    DATELOG=$(date)
    echo -e "$@"
    echo -e "$DATELOG $(basename $0): $@" >> $LOGFILE
  fi
}



cd $OUTDIR
log "====== news.json"
php create-json.php > news.json 2> /dev/null
#E.g :
#php news-lemonde.fr.php > lemonde.html 2> /dev/null
for gen in $(ls news-*|grep -v constants)
do
  log "====== $gen"
  output=$(echo $gen|cut -d'-' -f2|cut -d'.' -f1).html
  php $gen > $output 2>> $LOGFILE
done
log "Done."
log "=================================================================="
