<?php
include_once( 'news-constants.php' );

$rss_content = file_get_contents(NEWS_RSS_GUARDIAN);
$orgStrings = array( 'media:content');
$newStrings = array( 'mediacontent');
$rss_content  = str_replace($orgStrings, $newStrings, $rss_content);
$xml = simplexml_load_string($rss_content);
if ($xml === false) {
  echo 'Failed to read RSS';
} else {
  $channel = array();
  $channel['title'] = $xml->channel->title;
  $channel['link'] = $xml->channel->link;
  $channel['description'] = $xml->channel->description;
  $channel['pubDate'] = $xml->channel->pubDate;
  $channel['timestamp'] = strtotime($xml->channel->pubDate);
  echo '<h4>' . $channel['title'] . '</h4>';
  $cpt=0;
  foreach ($xml->channel->item as $item) {
    $article = array();
    $article['title'] = $item->title;
    $article['link'] = $item->link;
    $article['pubDate'] = $item->pubDate;
    $article['timestamp'] = strtotime($item->pubDate);
    $article['description'] = $item->description;
    $article['image'] = $item->mediacontent['url'];
    $articles[$cpt] = $article;

    echo '<div onclick="onArticle('.$cpt.')" style="display:inline;">';
    echo '<img id="img-guardian" src="'.$article['image'].'" style="display:inline;" width="100%"><br>';
    echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;';
    echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-down fa-2x"></i></a></div>&nbsp;';
    echo $article['title'].'&nbsp;&nbsp;';
    echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a><br></div></div>';
    $cpt++;
    if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
    }
  }
}

echo '</div><!-- ./col-4 -->'.PHP_EOL;
echo '<div id="article-display" class="col-6">'.PHP_EOL;
echo '<a name="article-top"></a><div id="article-current"></div>'.PHP_EOL;
echo '</div><!-- ./col-6 -->'.PHP_EOL;

$cpt=0;
foreach ($articles as $article ) {
  $cpt_prev=$cpt-1;
  $cpt_next=$cpt+1;
  echo '<!-- ==================== article '.$cpt.'============== -->';
  echo "<div class=\"article\" id=\"article-$cpt\" style=\"display: none;\">\n";
  echo "<hr>";
  echo "<a name=\"article-$cpt\">";
  $article_content = file_get_contents($article['link']);
  $doc = new DOMDocument();
  $doc->preserveWhiteSpace = false;
  $doc->formatOutput       = true;
  $libxml_previous_state = libxml_use_internal_errors(true);
  $doc->loadHTML($article_content);
  libxml_clear_errors();
  libxml_use_internal_errors($libxml_previous_state);
  $articles = $doc->getElementsByTagName('article');
  $article_only="";
  foreach ( $articles as $node) {
    $article_only = DOMinnerHTML($node);
  }
  //$article_only=$article_content;

//  $article_only = re_remove($article_only, '//');
  $article_only = re_remove($article_only, '/<span class="syndication__link button button--syndication-reprint button--small">Reuse this content<\/span>/');
  $article_only = re_remove($article_only, '/<span class=" u-h ">Share on Messenger<\/span>/');
  $article_only = re_remove($article_only, '/<span class=" u-h ">Share on WhatsApp<\/span>/');
  $article_only = re_remove($article_only, '/<span class=" u-h ">Share on Google+<\/span>/');
  $article_only = re_remove($article_only, '/<span class=" u-h ">Share on Pinterest<\/span>/');
  $article_only = re_remove($article_only, '/<span class=" u-h ">Share on LinkedIn<\/span>/');
  $article_only = re_remove($article_only, '/<input type="checkbox" id="show-caption" class="mobile-only u-h reveal-caption__checkbox"><label class="mobile-only reveal-caption reveal-caption--img" for="show-caption">/'); 
  $article_only = re_remove($article_only, '/<svg (.+?)><\/path><\/svg>/'); 
  $article_only = re_remove($article_only, '/<span class="inline-icon__fallback button">(.+?)<\/span>/'); 
  $article_only = preg_replace('/<span class="inline-expand-image inline-icon centered-icon rounded-icon article__fullscreen modern-visible">/', '<span>', $article_only);
  $article_only = preg_replace('/<li class="social__item social__item--(.+?)>/', '<li>', $article_only);
  $article_only = preg_replace('/<span class="inline-share-(.+?)>/', '<span>', $article_only);
//  $article_only = preg_replace('//', '<span>', $article_only);
  $article_only = preg_replace('/<a class="syndication__action" data-link-name="meta-syndication-article" (.+?)>/', '<span>', $article_only);
  $article_only = preg_replace('/<a class="social__action js-social__action--bottom social-icon-wrapper" (.+?)>/', '<a>', $article_only);
  $article_only = preg_replace('/<div class="u-responsive-ratio" style="padding-bottom: (.+?)">/', '<div>', $article_only);
  $article_only = preg_replace('/<ul class="social social--top js-social--top u-unstyled u-cf" data-component="social">/', '<ul style="display:none;">', $article_only);
  $article_only = preg_replace('/<div class="submeta__syndication">/', '<div style="display:none;">', $article_only);
  $article_only = preg_replace('/<div data-component="share" class="submeta__share">/', '<div style="display:none;">', $article_only);
  $article_only = preg_replace('/<div data-component="share" class="submeta__keywords">/', '<div style="display:none;">', $article_only);
  $article_only = preg_replace('/<div class="submeta__section-labels">/', '<div style="display:none;">', $article_only);
  $article_only = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $article_only);
  
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div>';
  echo '<div class="extract-content" id="'.$cpt.'">'."<h1>".$article['title']."</h1>".$article_only.'</div>';
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-up fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div></div>';
  $cpt++;
  if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
  }
}
?>
