<?php
include_once( 'news-constants.php' );

$rss_content = file_get_contents(NEWS_RSS_SMH);
$xml = simplexml_load_string($rss_content);
if ($xml === false) {
  echo 'Failed to read RSS';
} else {
  $channel = array();
  $channel['title'] = $xml->channel->title;
  $channel['link'] = $xml->channel->link;
  $channel['description'] = $xml->channel->description;
  $channel['pubDate'] = $xml->channel->pubDate;
  $channel['timestamp'] = strtotime($xml->channel->pubDate);
  echo '<h4>' . $channel['title'] . '</h4>';
  $cpt=0;
  foreach ($xml->channel->item as $item) {
    $article = array();
    $article['title'] = $item->title;
    $article['link'] = $item->link;
    $SEARCHREF="?ref=rss";
    //Remove reference from links
    $posref=strpos($article['link'], $SEARCHREF);
    if( $posref ) {
      $article['link'] = substr($article['link'],0,$posref);
    }
    $article['pubDate'] = $item->pubDate;
    $article['timestamp'] = strtotime($item->pubDate);
    $article['description'] = $item->description;
    $article['image']=$item->mediacontent['url'];
    $articles[$cpt] = $article;
    echo '<div onclick="onArticle('.$cpt.')" style="display:inline;">';
    echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;';
    echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-down fa-2x"></i></a></div>&nbsp;';
    echo $article['title'].'&nbsp;&nbsp;';
    echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a><br></div></div>';
    $cpt++;
    if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
    }
  }
}

echo '</div><!-- ./col-4 -->'.PHP_EOL;
echo '<div id="article-display" class="col-6">'.PHP_EOL;
echo '<a name="article-top"></a><div id="article-current"></div>'.PHP_EOL;
echo '</div><!-- ./col-6 -->'.PHP_EOL;

$cpt=0;
foreach ($articles as $article ) {
  $cpt_prev=$cpt-1;
  $cpt_next=$cpt+1;
  echo '<!-- ==================== article '.$cpt.'============== -->';
  echo "<div class=\"article\" id=\"article-$cpt\" style=\"display: none;\">\n";
  echo "<hr>";
  echo "<a name=\"article-$cpt\">";
  $article_content = file_get_contents($article['link']);
  $doc = new DOMDocument();
  $doc->preserveWhiteSpace = false;
  $doc->formatOutput       = true;
  $libxml_previous_state = libxml_use_internal_errors(true);
  $doc->loadHTML($article_content);
  libxml_clear_errors();
  libxml_use_internal_errors($libxml_previous_state);
  $articles = $doc->getElementsByTagName('article');
  $article_only="";
  if( isset( $articles[0] ) ) {
    $article_only=DOMinnerHTML($articles[0]);
  }
  
  //Clean some sections
	//$article_only = re_remove($article_only, '//');
	$article_only = re_remove($article_only, '/<header class="_2qhpu"><h2 class="_2qhpu">Most Viewed in (.+)<\/h2><\/header>/');
	$article_only = re_remove($article_only, '/<div><section aria-live="polite" aria-busy="true" class="_2zaYr" style="height:380px"><div class="_29X_Z"><span class="_2wzgv D5idv _3lVFK"><span class="_29Qt8"><\/span><span class="_3qqDc">Loading<\/span><\/span><\/div><\/section><\/div>/');
	$article_only = re_remove($article_only, '/<div class="_8Cum8"><a class="_4oUp_" href="(.+?)">License this article<\/a><\/div>/');
	$article_only = re_remove($article_only, '/<p class="_3MW1W">Our new podcast series from the team behind Phoebe\'s Fall<\/p>/');
	$article_only = re_remove($article_only, '/<p class="_29xCU"><svg class="QMY9O" height="18px" width="18px" aria-hidden="true" focusable="false"><use xlink:href="#icon-headphones"><\/use><\/svg>View episodes<\/p>/');
	$article_only = re_remove($article_only, '/<p class="ZybjO">A relationship banned under traditional law.<\/p>/');
	$article_only = re_remove($article_only, '/<section class="aKWhn noPrint"><div class="dLGbc"><\/div><\/section>/');
	$article_only = re_remove($article_only, '/<button class="_30X7v _2-NUy">(.+)<\/button>/');
	$article_only = re_remove($article_only, '/<script type="application\/ld\+json">(.+)<\/script>/');
	$article_only = re_remove($article_only, '/<div id="adspot-N-6x2-pos1" class="_1-uzy"><\/div>/');
	$article_only = re_remove($article_only, '/<div id="adspot-N-300x164-pos1" class="_1-uzy"><\/div>/');
	$article_only = re_remove($article_only, '/<div class="noPrint"><\/div>/');
	$article_only = re_remove($article_only, '/<script src="https:\/\/ad.doubleclick.net\/(.+)<\/script>/');
	$article_only = re_remove($article_only, '/<div class="ymInT _3uJpn noPrint"><span class="_2wzgv D5idv _3lVFK"><span class="_29Qt8"><\/span><span class="_3qqDc">Loading<\/span><\/span><\/div>/');
	$article_only = re_remove($article_only, '/<div class="_1lC_G"><\/div>/');
	$article_only = re_remove($article_only, '/<div class="_1H_qO"><\/div>/');
	$article_only = re_remove($article_only, '/<p> <\/p>/');

  //Finally remove empty lines
	$article_only = preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $article_only);
  
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div>';
  //echo '<div class="extract-content" id="'.$cpt.'">'.'<h1>'.$article['title'].'</h1>'.$article_only.'</div>';
  echo '<div class="extract-content" id="'.$cpt.'">'.$article_only.'</div>';
  echo '<div id="nav-up" style="display:inline;"><a href="#top"><i class="fa fa-home fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-up" style="display:inline;"><a href="#article-top"><i class="fa fa-chevron-up fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-source" style="display:inline;"><a href="'.$article['link'].'" target="new-'.$cpt.'"><i class="fa fa-link fa-2x"></i></a></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-prev" onclick="onArticle('.$cpt_prev.')" style="display:inline;"><i class="fa fa-chevron-left fa-2x"></i></div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
  echo '<div id="nav-next" onclick="onArticle('.$cpt_next.')" style="display:inline;"><i class="fa fa-chevron-right fa-2x"></i></div></div>';
  $cpt++;
  if( $cpt > $NEWS_RSS_MAX_ITEMS ) {
      break;
  }
}
?>


