# Tiny Application server for ThingPark

Script to automatically build a tiny HTTP Application Server statically for crossplatform.
Packets are stored in a sqlite3 database.

# Requirements

- arm6, arm7, riscv64

```
sudo apt install gcc-arm-linux-gnueabi \
    g++-arm-linux-gnueabi \
    gcc-arm-linux-gnueabihf \
    g++-arm-linux-gnueabihf \
    cpp-riscv64-linux-gnu \
    gcc-13-riscv64-linux-gnu \
    musl-dev \
    musl-tools \
    musl
```

- aarch64
See [here](https://developer.arm.com/downloads/-/arm-gnu-toolchain-downloads/14-2-rel1) to download the toolchain
Select **AArch64 GNU/Linux target (aarch64-none-linux-gnu)** and download the [archive](https://developer.arm.com/-/media/Files/downloads/gnu/14.2.rel1/binrel/arm-gnu-toolchain-14.2.rel1-x86_64-aarch64-none-linux-gnu.tar.xz)

```
export VERSION="14.2.rel1"
wget https://developer.arm.com/-/media/Files/downloads/gnu/$VERSION/binrel/arm-gnu-toolchain-$VERSION-x86_64-aarch64-none-linux-gnu.tar.xz
tar xJf arm-gnu-toolchain-$VERSION-x86_64-aarch64-none-linux-gnu.tar.xz -C $HOME/dev/
```

Toolchain will now be installed in **$HOME/arm-gnu-toolchain-14.2.rel1-x86_64-aarch64-none-linux-gnu**

# Build time

Building single file sqlite3 is long.
On **Intel(R) Core(TM) i5-6400 CPU @ 2.70GHz** with 4 cores and 16GB RAM took 6min30s to complete all targets.
