#!/bin/bash
TINYDNS=$1
SERVER="1.1.1.1"
PORT=53

if [ "$TINYDNS" == "" ]
then
  TINYDNS="./tinydns"
fi

for domain in kawi.fr bin.kawi.fr sg.kawi.fr
do
  for dns in A AAAA CNAME MX
  do
    for proto in " " -u
    do
      echo "Testing $domain $dns $proto"
      $TINYDNS -h $SERVER -p $PORT -q $dns $proto $domain
    done
    echo ""
  done
  echo ""
  echo ""
done

for domain in kawi.fr bin.kawi.fr sg.kawi.fr
do
  dns="A"
  echo "Testing $domain $dns $proto"
  $TINYDNS -h $SERVER -p $PORT -q $dns --time $domain
  echo ""
done
